
///////////////////////////////////////////////////////////////////
////                                                             ////
////  AES Test Bench                                             ////
////                                                             ////
////                                                             ////
////  Author: Rudolf Usselmann                                   ////
////          rudi@asics.ws                                      ////
////                                                             ////
////                                                             ////
////  Downloaded from: http://www.opencores.org/cores/aes_core/  ////
////                                                             ////
/////////////////////////////////////////////////////////////////////
////                                                             ////
//// Copyright (C) 2000-2002 Rudolf Usselmann                    ////
////                         www.asics.ws                        ////
////                         rudi@asics.ws                       ////
////                                                             ////
//// This source file may be used and distributed without        ////
//// restriction provided that this copyright statement is not   ////
//// removed from the file and that any derivative work contains ////
//// the original copyright notice and the associated disclaimer.////
////                                                             ////
////     THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY     ////
//// EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED   ////
//// TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS   ////
//// FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL THE AUTHOR      ////
//// OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,         ////
//// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES    ////
//// (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE   ////
//// GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR        ////
//// BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF  ////
//// LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT  ////
//// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT  ////
//// OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE         ////
//// POSSIBILITY OF SUCH DAMAGE.                                 ////
////                                                             ////
/////////////////////////////////////////////////////////////////////

//  CVS Log
//
//  $Id: test_bench_top.v,v 1.1.1.1 2005/08/03 14:59:38 kesava Exp $
//
//  $Date: 2005/08/03 14:59:38 $
//  $Revision: 1.1.1.1 $
//  $Author: kesava $
//  $Locker:  $
//  $State: Exp $
//
// Change History:
//               $Log: test_bench_top.v,v $
//               Revision 1.1.1.1  2005/08/03 14:59:38  kesava
//               ssi3Aug05
//
//               Revision 1.2  2002/11/12 16:10:12  rudi
//
//               Improved test bench, added missing timescale file.
//
//               Revision 1.1.1.1  2002/11/09 11:22:56  rudi
//               Initial Checkin
//
//
//
//
//
//
`timescale 1ns/1ps
//`include "timescale.v"
//`delay_mode_path
module test;

  reg		clk;
  reg		rst;

  reg [383:0]   tv[512:0];	// Test vectors
  wire [383:0]  tmp;
  reg		kld;
  wire [127:0]  key, plain, ciph;
  wire [127:0]  text_in;
  wire [127:0]  text_out;
  wire [127:0]  text_out2;
  reg [127:0]   text_exp;
  wire		done, done2;
  integer       n, error_cnt;


  initial
    begin
      $display("\n\n");
      $display("*****************************************************");
      $display("* AES Test bench ...");
      $display("*****************************************************");
      $display("\n");
`ifdef WAVES
      $shm_open("waves");
      $shm_probe("AS",test,"AS");
      $display("INFO: Signal dump enabled ...\n\n");
`endif
      
      while(1)
        begin
	  kld = 0;
	  clk <= 0;
	  rst = 0;
	  error_cnt = 0;
	  repeat(4)	@(posedge clk);
	  rst = 1;
	  repeat(20)	@(posedge clk);

	  $display("");
	  $display("");
	  $display("Started random test ...");

          tv[0]= 384'h00000000000000000000000000000000f34481ec3cc627bacd5dc3fb08f273e60336763e966d92595a567cc9ce537f5e;
          tv[1]= 384'h000000000000000000000000000000009798c4640bad75c7c3227db910174e72a9a1631bf4996954ebc093957b234589;
          tv[2]= 384'h0000000000000000000000000000000096ab5c2ff612d9dfaae8c31f30c42168ff4f8391a6a40ca5b25d23bedd44a597;
          tv[3]= 384'h000000000000000000000000000000006a118a874519e64e9963798a503f1d35dc43be40be0e53712f7e2bf5ca707209;
          tv[4]= 384'h00000000000000000000000000000000cb9fceec81286ca3e989bd979b0cb28492beedab1895a94faa69b632e5cc47ce;
          tv[5]= 384'h00000000000000000000000000000000b26aeb1874e47ca8358ff22378f09144459264f4798f6a78bacb89c15ed3d601;
          tv[6]= 384'h0000000000000000000000000000000058c8e00b2631686d54eab84b91f0aca108a4e2efec8a8e3312ca7460b9040bbf;
          tv[7]= 384'h10a58869d74be5a374cf867cfb473859000000000000000000000000000000006d251e6944b051e04eaa6fb4dbf78465;
          tv[8]= 384'hcaea65cdbb75e9169ecd22ebe6e54675000000000000000000000000000000006e29201190152df4ee058139def610bb;
          tv[9]= 384'ha2e2fa9baf7d20822ca9f0542f764a4100000000000000000000000000000000c3b44b95d9d2f25670eee9a0de099fa3;
          tv[10]= 384'hb6364ac4e1de1e285eaf144a2415f7a0000000000000000000000000000000005d9b05578fc944b3cf1ccf0e746cd581;
          tv[11]= 384'h64cf9c7abc50b888af65f49d521944b200000000000000000000000000000000f7efc89d5dba578104016ce5ad659c05;
          tv[12]= 384'h47d6742eefcc0465dc96355e851b64d9000000000000000000000000000000000306194f666d183624aa230a8b264ae7;
          tv[13]= 384'h3eb39790678c56bee34bbcdeccf6cdb500000000000000000000000000000000858075d536d79ccee571f7d7204b1f67;
          tv[14]= 384'h64110a924f0743d500ccadae72c134270000000000000000000000000000000035870c6a57e9e92314bcb8087cde72ce;
          tv[15]= 384'h18d8126516f8a12ab1a36d9f04d68e51000000000000000000000000000000006c68e9be5ec41e22c825b7c7affb4363;
          tv[16]= 384'hf530357968578480b398a3c251cd109300000000000000000000000000000000f5df39990fc688f1b07224cc03e86cea;
          tv[17]= 384'hda84367f325d42d601b4326964802e8e00000000000000000000000000000000bba071bcb470f8f6586e5d3add18bc66;
          tv[18]= 384'he37b1c6aa2846f6fdb413f238b089f230000000000000000000000000000000043c9f7e62f5d288bb27aa40ef8fe1ea8;
          tv[19]= 384'h6c002b682483e0cabcc731c253be5674000000000000000000000000000000003580d19cff44f1014a7c966a69059de5;
          tv[20]= 384'h143ae8ed6555aba96110ab58893a8ae100000000000000000000000000000000806da864dd29d48deafbe764f8202aef;
          tv[21]= 384'hb69418a85332240dc82492353956ae0c00000000000000000000000000000000a303d940ded8f0baff6f75414cac5243;
          tv[22]= 384'h71b5c08a1993e1362e4d0ce9b22b78d500000000000000000000000000000000c2dabd117f8a3ecabfbb11d12194d9d0;
          tv[23]= 384'he234cdca2606b81f29408d5f6da2120600000000000000000000000000000000fff60a4740086b3b9c56195b98d91a7b;
          tv[24]= 384'h13237c49074a3da078dc1d828bb78c6f000000000000000000000000000000008146a08e2357f0caa30ca8c94d1a0544;
          tv[25]= 384'h3071a2a48fe6cbd04f1a129098e308f8000000000000000000000000000000004b98e06d356deb07ebb824e5713f7be3;
          tv[26]= 384'h90f42ec0f68385f2ffc5dfc03a654dce000000000000000000000000000000007a20a53d460fc9ce0423a7a0764c6cf2;
          tv[27]= 384'hfebd9a24d8b65c1c787d50a4ed3619a900000000000000000000000000000000f4a70d8af877f9b02b4c40df57d45b17;
          tv[28]= 384'h80000000000000000000000000000000000000000000000000000000000000000edd33d3c621e546455bd8ba1418bec8;
          tv[29]= 384'hc0000000000000000000000000000000000000000000000000000000000000004bc3f883450c113c64ca42e1112a9e87;
          tv[30]= 384'he00000000000000000000000000000000000000000000000000000000000000072a1da770f5d7ac4c9ef94d822affd97;
          tv[31]= 384'hf000000000000000000000000000000000000000000000000000000000000000970014d634e2b7650777e8e84d03ccd8;
          tv[32]= 384'hf800000000000000000000000000000000000000000000000000000000000000f17e79aed0db7e279e955b5f493875a7;
          tv[33]= 384'hfc000000000000000000000000000000000000000000000000000000000000009ed5a75136a940d0963da379db4af26a;
          tv[34]= 384'hfe00000000000000000000000000000000000000000000000000000000000000c4295f83465c7755e8fa364bac6a7ea5;
          tv[35]= 384'hff00000000000000000000000000000000000000000000000000000000000000b1d758256b28fd850ad4944208cf1155;
          tv[36]= 384'hff8000000000000000000000000000000000000000000000000000000000000042ffb34c743de4d88ca38011c990890b;
          tv[37]= 384'hffc00000000000000000000000000000000000000000000000000000000000009958f0ecea8b2172c0c1995f9182c0f3;
          tv[38]= 384'hffe0000000000000000000000000000000000000000000000000000000000000956d7798fac20f82a8823f984d06f7f5;
          tv[39]= 384'hfff0000000000000000000000000000000000000000000000000000000000000a01bf44f2d16be928ca44aaf7b9b106b;
          tv[40]= 384'hfff8000000000000000000000000000000000000000000000000000000000000b5f1a33e50d40d103764c76bd4c6b6f8;
          tv[41]= 384'hfffc0000000000000000000000000000000000000000000000000000000000002637050c9fc0d4817e2d69de878aee8d;
          tv[42]= 384'hfffe000000000000000000000000000000000000000000000000000000000000113ecbe4a453269a0dd26069467fb5b5;
          tv[43]= 384'hffff00000000000000000000000000000000000000000000000000000000000097d0754fe68f11b9e375d070a608c884;
          tv[44]= 384'hffff800000000000000000000000000000000000000000000000000000000000c6a0b3e998d05068a5399778405200b4;
          tv[45]= 384'hffffc00000000000000000000000000000000000000000000000000000000000df556a33438db87bc41b1752c55e5e49;
          tv[46]= 384'hffffe0000000000000000000000000000000000000000000000000000000000090fb128d3a1af6e548521bb962bf1f05;
          tv[47]= 384'hfffff0000000000000000000000000000000000000000000000000000000000026298e9c1db517c215fadfb7d2a8d691;
          tv[48]= 384'hfffff80000000000000000000000000000000000000000000000000000000000a6cb761d61f8292d0df393a279ad0380;
          tv[49]= 384'hfffffc000000000000000000000000000000000000000000000000000000000012acd89b13cd5f8726e34d44fd486108;
          tv[50]= 384'hfffffe000000000000000000000000000000000000000000000000000000000095b1703fc57ba09fe0c3580febdd7ed4;
          tv[51]= 384'hffffff0000000000000000000000000000000000000000000000000000000000de11722d893e9f9121c381becc1da59a;
          tv[52]= 384'hffffff80000000000000000000000000000000000000000000000000000000006d114ccb27bf391012e8974c546d9bf2;
          tv[53]= 384'hffffffc0000000000000000000000000000000000000000000000000000000005ce37e17eb4646ecfac29b9cc38d9340;
          tv[54]= 384'hffffffe00000000000000000000000000000000000000000000000000000000018c1b6e2157122056d0243d8a165cddb;
          tv[55]= 384'hfffffff00000000000000000000000000000000000000000000000000000000099693e6a59d1366c74d823562d7e1431;
          tv[56]= 384'hfffffff8000000000000000000000000000000000000000000000000000000006c7c64dc84a8bba758ed17eb025a57e3;
          tv[57]= 384'hfffffffc00000000000000000000000000000000000000000000000000000000e17bc79f30eaab2fac2cbbe3458d687a;
          tv[58]= 384'hfffffffe000000000000000000000000000000000000000000000000000000001114bc2028009b923f0b01915ce5e7c4;
          tv[59]= 384'hffffffff000000000000000000000000000000000000000000000000000000009c28524a16a1e1c1452971caa8d13476;
          tv[60]= 384'hffffffff80000000000000000000000000000000000000000000000000000000ed62e16363638360fdd6ad62112794f0;
          tv[61]= 384'hffffffffc00000000000000000000000000000000000000000000000000000005a8688f0b2a2c16224c161658ffd4044;
          tv[62]= 384'hffffffffe000000000000000000000000000000000000000000000000000000023f710842b9bb9c32f26648c786807ca;
          tv[63]= 384'hfffffffff000000000000000000000000000000000000000000000000000000044a98bf11e163f632c47ec6a49683a89;
          tv[64]= 384'hfffffffff80000000000000000000000000000000000000000000000000000000f18aff94274696d9b61848bd50ac5e5;
          tv[65]= 384'hfffffffffc00000000000000000000000000000000000000000000000000000082408571c3e2424540207f833b6dda69;
          tv[66]= 384'hfffffffffe000000000000000000000000000000000000000000000000000000303ff996947f0c7d1f43c8f3027b9b75;
          tv[67]= 384'hffffffffff0000000000000000000000000000000000000000000000000000007df4daf4ad29a3615a9b6ece5c99518a;
          tv[68]= 384'hffffffffff800000000000000000000000000000000000000000000000000000c72954a48d0774db0b4971c526260415;
          tv[69]= 384'hffffffffffc000000000000000000000000000000000000000000000000000001df9b76112dc6531e07d2cfda04411f0;
          tv[70]= 384'hffffffffffe000000000000000000000000000000000000000000000000000008e4d8e699119e1fc87545a647fb1d34f;
          tv[71]= 384'hfffffffffff00000000000000000000000000000000000000000000000000000e6c4807ae11f36f091c57d9fb68548d1;
          tv[72]= 384'hfffffffffff800000000000000000000000000000000000000000000000000008ebf73aad49c82007f77a5c1ccec6ab4;
          tv[73]= 384'hfffffffffffc00000000000000000000000000000000000000000000000000004fb288cc2040049001d2c7585ad123fc;
          tv[74]= 384'hfffffffffffe000000000000000000000000000000000000000000000000000004497110efb9dceb13e2b13fb4465564;
          tv[75]= 384'hffffffffffff000000000000000000000000000000000000000000000000000075550e6cb5a88e49634c9ab69eda0430;
          tv[76]= 384'hffffffffffff8000000000000000000000000000000000000000000000000000b6768473ce9843ea66a81405dd50b345;
          tv[77]= 384'hffffffffffffc000000000000000000000000000000000000000000000000000cb2f430383f9084e03a653571e065de6;
          tv[78]= 384'hffffffffffffe000000000000000000000000000000000000000000000000000ff4e66c07bae3e79fb7d210847a3b0ba;
          tv[79]= 384'hfffffffffffff0000000000000000000000000000000000000000000000000007b90785125505fad59b13c186dd66ce3;
          tv[80]= 384'hfffffffffffff8000000000000000000000000000000000000000000000000008b527a6aebdaec9eaef8eda2cb7783e5;
          tv[81]= 384'hfffffffffffffc0000000000000000000000000000000000000000000000000043fdaf53ebbc9880c228617d6a9b548b;
          tv[82]= 384'hfffffffffffffe0000000000000000000000000000000000000000000000000053786104b9744b98f052c46f1c850d0b;
          tv[83]= 384'hffffffffffffff00000000000000000000000000000000000000000000000000b5ab3013dd1e61df06cbaf34ca2aee78;
          tv[84]= 384'hffffffffffffff800000000000000000000000000000000000000000000000007470469be9723030fdcc73a8cd4fbb10;
          tv[85]= 384'hffffffffffffffc0000000000000000000000000000000000000000000000000a35a63f5343ebe9ef8167bcb48ad122e;
          tv[86]= 384'hffffffffffffffe0000000000000000000000000000000000000000000000000fd8687f0757a210e9fdf181204c30863;
          tv[87]= 384'hfffffffffffffff00000000000000000000000000000000000000000000000007a181e84bd5457d26a88fbae96018fb0;
          tv[88]= 384'hfffffffffffffff8000000000000000000000000000000000000000000000000653317b9362b6f9b9e1a580e68d494b5;
          tv[89]= 384'hfffffffffffffffc000000000000000000000000000000000000000000000000995c9dc0b689f03c45867b5faa5c18d1;
          tv[90]= 384'hfffffffffffffffe00000000000000000000000000000000000000000000000077a4d96d56dda398b9aabecfc75729fd;
          tv[91]= 384'hffffffffffffffff00000000000000000000000000000000000000000000000084be19e053635f09f2665e7bae85b42d;
          tv[92]= 384'hffffffffffffffff80000000000000000000000000000000000000000000000032cd652842926aea4aa6137bb2be2b5e;
          tv[93]= 384'hffffffffffffffffc00000000000000000000000000000000000000000000000493d4a4f38ebb337d10aa84e9171a554;
          tv[94]= 384'hffffffffffffffffe00000000000000000000000000000000000000000000000d9bff7ff454b0ec5a4a2a69566e2cb84;
          tv[95]= 384'hfffffffffffffffff000000000000000000000000000000000000000000000003535d565ace3f31eb249ba2cc6765d7a;
          tv[96]= 384'hfffffffffffffffff80000000000000000000000000000000000000000000000f60e91fc3269eecf3231c6e9945697c6;
          tv[97]= 384'hfffffffffffffffffc0000000000000000000000000000000000000000000000ab69cfadf51f8e604d9cc37182f6635a;
          tv[98]= 384'hfffffffffffffffffe00000000000000000000000000000000000000000000007866373f24a0b6ed56e0d96fcdafb877;
          tv[99]= 384'hffffffffffffffffff00000000000000000000000000000000000000000000001ea448c2aac954f5d812e9d78494446a;
          tv[100]= 384'hffffffffffffffffff8000000000000000000000000000000000000000000000acc5599dd8ac02239a0fef4a36dd1668;
          tv[101]= 384'hffffffffffffffffffc000000000000000000000000000000000000000000000d8764468bb103828cf7e1473ce895073;
          tv[102]= 384'hffffffffffffffffffe0000000000000000000000000000000000000000000001b0d02893683b9f180458e4aa6b73982;
          tv[103]= 384'hfffffffffffffffffff00000000000000000000000000000000000000000000096d9b017d302df410a937dcdb8bb6e43;
          tv[104]= 384'hfffffffffffffffffff800000000000000000000000000000000000000000000ef1623cc44313cff440b1594a7e21cc6;
          tv[105]= 384'hfffffffffffffffffffc00000000000000000000000000000000000000000000284ca2fa35807b8b0ae4d19e11d7dbd7;
          tv[106]= 384'hfffffffffffffffffffe00000000000000000000000000000000000000000000f2e976875755f9401d54f36e2a23a594;
          tv[107]= 384'hffffffffffffffffffff00000000000000000000000000000000000000000000ec198a18e10e532403b7e20887c8dd80;
          tv[108]= 384'hffffffffffffffffffff80000000000000000000000000000000000000000000545d50ebd919e4a6949d96ad47e46a80;
          tv[109]= 384'hffffffffffffffffffffc0000000000000000000000000000000000000000000dbdfb527060e0a71009c7bb0c68f1d44;
          tv[110]= 384'hffffffffffffffffffffe00000000000000000000000000000000000000000009cfa1322ea33da2173a024f2ff0d896d;
          tv[111]= 384'hfffffffffffffffffffff00000000000000000000000000000000000000000008785b1a75b0f3bd958dcd0e29318c521;
          tv[112]= 384'hfffffffffffffffffffff800000000000000000000000000000000000000000038f67b9e98e4a97b6df030a9fcdd0104;
          tv[113]= 384'hfffffffffffffffffffffc000000000000000000000000000000000000000000192afffb2c880e82b05926d0fc6c448b;
          tv[114]= 384'hfffffffffffffffffffffe0000000000000000000000000000000000000000006a7980ce7b105cf530952d74daaf798c;
          tv[115]= 384'hffffffffffffffffffffff000000000000000000000000000000000000000000ea3695e1351b9d6858bd958cf513ef6c;
          tv[116]= 384'hffffffffffffffffffffff8000000000000000000000000000000000000000006da0490ba0ba0343b935681d2cce5ba1;
          tv[117]= 384'hffffffffffffffffffffffc00000000000000000000000000000000000000000f0ea23af08534011c60009ab29ada2f1;
          tv[118]= 384'hffffffffffffffffffffffe00000000000000000000000000000000000000000ff13806cf19cc38721554d7c0fcdcd4b;
          tv[119]= 384'hfffffffffffffffffffffff000000000000000000000000000000000000000006838af1f4f69bae9d85dd188dcdf0688;
          tv[120]= 384'hfffffffffffffffffffffff8000000000000000000000000000000000000000036cf44c92d550bfb1ed28ef583ddf5d7;
          tv[121]= 384'hfffffffffffffffffffffffc0000000000000000000000000000000000000000d06e3195b5376f109d5c4ec6c5d62ced;
          tv[122]= 384'hfffffffffffffffffffffffe0000000000000000000000000000000000000000c440de014d3d610707279b13242a5c36;
          tv[123]= 384'hffffffffffffffffffffffff0000000000000000000000000000000000000000f0c5c6ffa5e0bd3a94c88f6b6f7c16b9;
          tv[124]= 384'hffffffffffffffffffffffff80000000000000000000000000000000000000003e40c3901cd7effc22bffc35dee0b4d9;
          tv[125]= 384'hffffffffffffffffffffffffc000000000000000000000000000000000000000b63305c72bedfab97382c406d0c49bc6;
          tv[126]= 384'hffffffffffffffffffffffffe00000000000000000000000000000000000000036bbaab22a6bd4925a99a2b408d2dbae;
          tv[127]= 384'hfffffffffffffffffffffffff000000000000000000000000000000000000000307c5b8fcd0533ab98bc51e27a6ce461;
          tv[128]= 384'hfffffffffffffffffffffffff800000000000000000000000000000000000000829c04ff4c07513c0b3ef05c03e337b5;
          tv[129]= 384'hfffffffffffffffffffffffffc00000000000000000000000000000000000000f17af0e895dda5eb98efc68066e84c54;
          tv[130]= 384'hfffffffffffffffffffffffffe00000000000000000000000000000000000000277167f3812afff1ffacb4a934379fc3;
          tv[131]= 384'hffffffffffffffffffffffffff000000000000000000000000000000000000002cb1dc3a9c72972e425ae2ef3eb597cd;
          tv[132]= 384'hffffffffffffffffffffffffff8000000000000000000000000000000000000036aeaa3a213e968d4b5b679d3a2c97fe;
          tv[133]= 384'hffffffffffffffffffffffffffc00000000000000000000000000000000000009241daca4fdd034a82372db50e1a0f3f;
          tv[134]= 384'hffffffffffffffffffffffffffe0000000000000000000000000000000000000c14574d9cd00cf2b5a7f77e53cd57885;
          tv[135]= 384'hfffffffffffffffffffffffffff0000000000000000000000000000000000000793de39236570aba83ab9b737cb521c9;
          tv[136]= 384'hfffffffffffffffffffffffffff800000000000000000000000000000000000016591c0f27d60e29b85a96c33861a7ef;
          tv[137]= 384'hfffffffffffffffffffffffffffc00000000000000000000000000000000000044fb5c4d4f5cb79be5c174a3b1c97348;
          tv[138]= 384'hfffffffffffffffffffffffffffe000000000000000000000000000000000000674d2b61633d162be59dde04222f4740;
          tv[139]= 384'hffffffffffffffffffffffffffff000000000000000000000000000000000000b4750ff263a65e1f9e924ccfd98f3e37;
          tv[140]= 384'hffffffffffffffffffffffffffff80000000000000000000000000000000000062d0662d6eaeddedebae7f7ea3a4f6b6;
          tv[141]= 384'hffffffffffffffffffffffffffffc0000000000000000000000000000000000070c46bb30692be657f7eaa93ebad9897;
          tv[142]= 384'hffffffffffffffffffffffffffffe00000000000000000000000000000000000323994cfb9da285a5d9642e1759b224a;
          tv[143]= 384'hfffffffffffffffffffffffffffff000000000000000000000000000000000001dbf57877b7b17385c85d0b54851e371;
          tv[144]= 384'hfffffffffffffffffffffffffffff80000000000000000000000000000000000dfa5c097cdc1532ac071d57b1d28d1bd;
          tv[145]= 384'hfffffffffffffffffffffffffffffc00000000000000000000000000000000003a0c53fa37311fc10bd2a9981f513174;
          tv[146]= 384'hfffffffffffffffffffffffffffffe0000000000000000000000000000000000ba4f970c0a25c41814bdae2e506be3b4;
          tv[147]= 384'hffffffffffffffffffffffffffffff00000000000000000000000000000000002dce3acb727cd13ccd76d425ea56e4f6;
          tv[148]= 384'hffffffffffffffffffffffffffffff80000000000000000000000000000000005160474d504b9b3eefb68d35f245f4b3;
          tv[149]= 384'hffffffffffffffffffffffffffffffc00000000000000000000000000000000041a8a947766635dec37553d9a6c0cbb7;
          tv[150]= 384'hffffffffffffffffffffffffffffffe00000000000000000000000000000000025d6cfe6881f2bf497dd14cd4ddf445b;
          tv[151]= 384'hfffffffffffffffffffffffffffffff00000000000000000000000000000000041c78c135ed9e98c096640647265da1e;
          tv[152]= 384'hfffffffffffffffffffffffffffffff8000000000000000000000000000000005a4d404d8917e353e92a21072c3b2305;
          tv[153]= 384'hfffffffffffffffffffffffffffffffc0000000000000000000000000000000002bc96846b3fdc71643f384cd3cc3eaf;
          tv[154]= 384'hfffffffffffffffffffffffffffffffe000000000000000000000000000000009ba4a9143f4e5d4048521c4f8877d88e;
          tv[155]= 384'hffffffffffffffffffffffffffffffff00000000000000000000000000000000a1f6258c877d5fcd8964484538bfc92c;
          tv[156]= 384'h00000000000000000000000000000000800000000000000000000000000000003ad78e726c1ec02b7ebfe92b23d9ec34;
          tv[157]= 384'h00000000000000000000000000000000c0000000000000000000000000000000aae5939c8efdf2f04e60b9fe7117b2c2;
          tv[158]= 384'h00000000000000000000000000000000e0000000000000000000000000000000f031d4d74f5dcbf39daaf8ca3af6e527;
          tv[159]= 384'h00000000000000000000000000000000f000000000000000000000000000000096d9fd5cc4f07441727df0f33e401a36;
          tv[160]= 384'h00000000000000000000000000000000f800000000000000000000000000000030ccdb044646d7e1f3ccea3dca08b8c0;
          tv[161]= 384'h00000000000000000000000000000000fc00000000000000000000000000000016ae4ce5042a67ee8e177b7c587ecc82;
          tv[162]= 384'h00000000000000000000000000000000fe000000000000000000000000000000b6da0bb11a23855d9c5cb1b4c6412e0a;
          tv[163]= 384'h00000000000000000000000000000000ff000000000000000000000000000000db4f1aa530967d6732ce4715eb0ee24b;
          tv[164]= 384'h00000000000000000000000000000000ff800000000000000000000000000000a81738252621dd180a34f3455b4baa2f;
          tv[165]= 384'h00000000000000000000000000000000ffc0000000000000000000000000000077e2b508db7fd89234caf7939ee5621a;
          tv[166]= 384'h00000000000000000000000000000000ffe00000000000000000000000000000b8499c251f8442ee13f0933b688fcd19;
          tv[167]= 384'h00000000000000000000000000000000fff00000000000000000000000000000965135f8a81f25c9d630b17502f68e53;
          tv[168]= 384'h00000000000000000000000000000000fff800000000000000000000000000008b87145a01ad1c6cede995ea3670454f;
          tv[169]= 384'h00000000000000000000000000000000fffc00000000000000000000000000008eae3b10a0c8ca6d1d3b0fa61e56b0b2;
          tv[170]= 384'h00000000000000000000000000000000fffe000000000000000000000000000064b4d629810fda6bafdf08f3b0d8d2c5;
          tv[171]= 384'h00000000000000000000000000000000ffff0000000000000000000000000000d7e5dbd3324595f8fdc7d7c571da6c2a;
          tv[172]= 384'h00000000000000000000000000000000ffff8000000000000000000000000000f3f72375264e167fca9de2c1527d9606;
          tv[173]= 384'h00000000000000000000000000000000ffffc0000000000000000000000000008ee79dd4f401ff9b7ea945d86666c13b;
          tv[174]= 384'h00000000000000000000000000000000ffffe000000000000000000000000000dd35cea2799940b40db3f819cb94c08b;
          tv[175]= 384'h00000000000000000000000000000000fffff0000000000000000000000000006941cb6b3e08c2b7afa581ebdd607b87;
          tv[176]= 384'h00000000000000000000000000000000fffff8000000000000000000000000002c20f439f6bb097b29b8bd6d99aad799;
          tv[177]= 384'h00000000000000000000000000000000fffffc00000000000000000000000000625d01f058e565f77ae86378bd2c49b3;
          tv[178]= 384'h00000000000000000000000000000000fffffe00000000000000000000000000c0b5fd98190ef45fbb4301438d095950;
          tv[179]= 384'h00000000000000000000000000000000ffffff0000000000000000000000000013001ff5d99806efd25da34f56be854b;
          tv[180]= 384'h00000000000000000000000000000000ffffff800000000000000000000000003b594c60f5c8277a5113677f94208d82;
          tv[181]= 384'h00000000000000000000000000000000ffffffc0000000000000000000000000e9c0fc1818e4aa46bd2e39d638f89e05;
          tv[182]= 384'h00000000000000000000000000000000ffffffe0000000000000000000000000f8023ee9c3fdc45a019b4e985c7e1a54;
          tv[183]= 384'h00000000000000000000000000000000fffffff000000000000000000000000035f40182ab4662f3023baec1ee796b57;
          tv[184]= 384'h00000000000000000000000000000000fffffff80000000000000000000000003aebbad7303649b4194a6945c6cc3694;
          tv[185]= 384'h00000000000000000000000000000000fffffffc000000000000000000000000a2124bea53ec2834279bed7f7eb0f938;
          tv[186]= 384'h00000000000000000000000000000000fffffffe000000000000000000000000b9fb4399fa4facc7309e14ec98360b0a;
          tv[187]= 384'h00000000000000000000000000000000ffffffff000000000000000000000000c26277437420c5d634f715aea81a9132;
          tv[188]= 384'h00000000000000000000000000000000ffffffff800000000000000000000000171a0e1b2dd424f0e089af2c4c10f32f;
          tv[189]= 384'h00000000000000000000000000000000ffffffffc000000000000000000000007cadbe402d1b208fe735edce00aee7ce;
          tv[190]= 384'h00000000000000000000000000000000ffffffffe0000000000000000000000043b02ff929a1485af6f5c6d6558baa0f;
          tv[191]= 384'h00000000000000000000000000000000fffffffff00000000000000000000000092faacc9bf43508bf8fa8613ca75dea;
          tv[192]= 384'h00000000000000000000000000000000fffffffff80000000000000000000000cb2bf8280f3f9742c7ed513fe802629c;
          tv[193]= 384'h00000000000000000000000000000000fffffffffc0000000000000000000000215a41ee442fa992a6e323986ded3f68;
          tv[194]= 384'h00000000000000000000000000000000fffffffffe0000000000000000000000f21e99cf4f0f77cea836e11a2fe75fb1;
          tv[195]= 384'h00000000000000000000000000000000ffffffffff000000000000000000000095e3a0ca9079e646331df8b4e70d2cd6;
          tv[196]= 384'h00000000000000000000000000000000ffffffffff80000000000000000000004afe7f120ce7613f74fc12a01a828073;
          tv[197]= 384'h00000000000000000000000000000000ffffffffffc000000000000000000000827f000e75e2c8b9d479beed913fe678;
          tv[198]= 384'h00000000000000000000000000000000ffffffffffe00000000000000000000035830c8e7aaefe2d30310ef381cbf691;
          tv[199]= 384'h00000000000000000000000000000000fffffffffff000000000000000000000191aa0f2c8570144f38657ea4085ebe5;
          tv[200]= 384'h00000000000000000000000000000000fffffffffff80000000000000000000085062c2c909f15d9269b6c18ce99c4f0;
          tv[201]= 384'h00000000000000000000000000000000fffffffffffc00000000000000000000678034dc9e41b5a560ed239eeab1bc78;
          tv[202]= 384'h00000000000000000000000000000000fffffffffffe00000000000000000000c2f93a4ce5ab6d5d56f1b93cf19911c1;
          tv[203]= 384'h00000000000000000000000000000000ffffffffffff000000000000000000001c3112bcb0c1dcc749d799743691bf82;
          tv[204]= 384'h00000000000000000000000000000000ffffffffffff8000000000000000000000c55bd75c7f9c881989d3ec1911c0d4;
          tv[205]= 384'h00000000000000000000000000000000ffffffffffffc0000000000000000000ea2e6b5ef182b7dff3629abd6a12045f;
          tv[206]= 384'h00000000000000000000000000000000ffffffffffffe000000000000000000022322327e01780b17397f24087f8cc6f;
          tv[207]= 384'h00000000000000000000000000000000fffffffffffff0000000000000000000c9cacb5cd11692c373b2411768149ee7;
          tv[208]= 384'h00000000000000000000000000000000fffffffffffff8000000000000000000a18e3dbbca577860dab6b80da3139256;
          tv[209]= 384'h00000000000000000000000000000000fffffffffffffc00000000000000000079b61c37bf328ecca8d743265a3d425c;
          tv[210]= 384'h00000000000000000000000000000000fffffffffffffe000000000000000000d2d99c6bcc1f06fda8e27e8ae3f1ccc7;
          tv[211]= 384'h00000000000000000000000000000000ffffffffffffff0000000000000000001bfd4b91c701fd6b61b7f997829d663b;
          tv[212]= 384'h00000000000000000000000000000000ffffffffffffff80000000000000000011005d52f25f16bdc9545a876a63490a;
          tv[213]= 384'h00000000000000000000000000000000ffffffffffffffc000000000000000003a4d354f02bb5a5e47d39666867f246a;
          tv[214]= 384'h00000000000000000000000000000000ffffffffffffffe00000000000000000d451b8d6e1e1a0ebb155fbbf6e7b7dc3;
          tv[215]= 384'h00000000000000000000000000000000fffffffffffffff000000000000000006898d4f42fa7ba6a10ac05e87b9f2080;
          tv[216]= 384'h00000000000000000000000000000000fffffffffffffff80000000000000000b611295e739ca7d9b50f8e4c0e754a3f;
          tv[217]= 384'h00000000000000000000000000000000fffffffffffffffc00000000000000007d33fc7d8abe3ca1936759f8f5deaf20;
          tv[218]= 384'h00000000000000000000000000000000fffffffffffffffe00000000000000003b5e0f566dc96c298f0c12637539b25c;
          tv[219]= 384'h00000000000000000000000000000000ffffffffffffffff0000000000000000f807c3e7985fe0f5a50e2cdb25c5109e;
          tv[220]= 384'h00000000000000000000000000000000ffffffffffffffff800000000000000041f992a856fb278b389a62f5d274d7e9;
          tv[221]= 384'h00000000000000000000000000000000ffffffffffffffffc00000000000000010d3ed7a6fe15ab4d91acbc7d0767ab1;
          tv[222]= 384'h00000000000000000000000000000000ffffffffffffffffe00000000000000021feecd45b2e675973ac33bf0c5424fc;
          tv[223]= 384'h00000000000000000000000000000000fffffffffffffffff0000000000000001480cb3955ba62d09eea668f7c708817;
          tv[224]= 384'h00000000000000000000000000000000fffffffffffffffff80000000000000066404033d6b72b609354d5496e7eb511;
          tv[225]= 384'h00000000000000000000000000000000fffffffffffffffffc000000000000001c317a220a7d700da2b1e075b00266e1;
          tv[226]= 384'h00000000000000000000000000000000fffffffffffffffffe00000000000000ab3b89542233f1271bf8fd0c0f403545;
          tv[227]= 384'h00000000000000000000000000000000ffffffffffffffffff00000000000000d93eae966fac46dca927d6b114fa3f9e;
          tv[228]= 384'h00000000000000000000000000000000ffffffffffffffffff800000000000001bdec521316503d9d5ee65df3ea94ddf;
          tv[229]= 384'h00000000000000000000000000000000ffffffffffffffffffc0000000000000eef456431dea8b4acf83bdae3717f75f;
          tv[230]= 384'h00000000000000000000000000000000ffffffffffffffffffe000000000000006f2519a2fafaa596bfef5cfa15c21b9;
          tv[231]= 384'h00000000000000000000000000000000fffffffffffffffffff0000000000000251a7eac7e2fe809e4aa8d0d7012531a;
          tv[232]= 384'h00000000000000000000000000000000fffffffffffffffffff80000000000003bffc16e4c49b268a20f8d96a60b4058;
          tv[233]= 384'h00000000000000000000000000000000fffffffffffffffffffc000000000000e886f9281999c5bb3b3e8862e2f7c988;
          tv[234]= 384'h00000000000000000000000000000000fffffffffffffffffffe000000000000563bf90d61beef39f48dd625fcef1361;
          tv[235]= 384'h00000000000000000000000000000000ffffffffffffffffffff0000000000004d37c850644563c69fd0acd9a049325b;
          tv[236]= 384'h00000000000000000000000000000000ffffffffffffffffffff800000000000b87c921b91829ef3b13ca541ee1130a6;
          tv[237]= 384'h00000000000000000000000000000000ffffffffffffffffffffc000000000002e65eb6b6ea383e109accce8326b0393;
          tv[238]= 384'h00000000000000000000000000000000ffffffffffffffffffffe000000000009ca547f7439edc3e255c0f4d49aa8990;
          tv[239]= 384'h00000000000000000000000000000000fffffffffffffffffffff00000000000a5e652614c9300f37816b1f9fd0c87f9;
          tv[240]= 384'h00000000000000000000000000000000fffffffffffffffffffff8000000000014954f0b4697776f44494fe458d814ed;
          tv[241]= 384'h00000000000000000000000000000000fffffffffffffffffffffc00000000007c8d9ab6c2761723fe42f8bb506cbcf7;
          tv[242]= 384'h00000000000000000000000000000000fffffffffffffffffffffe0000000000db7e1932679fdd99742aab04aa0d5a80;
          tv[243]= 384'h00000000000000000000000000000000ffffffffffffffffffffff00000000004c6a1c83e568cd10f27c2d73ded19c28;
          tv[244]= 384'h00000000000000000000000000000000ffffffffffffffffffffff800000000090ecbe6177e674c98de412413f7ac915;
          tv[245]= 384'h00000000000000000000000000000000ffffffffffffffffffffffc00000000090684a2ac55fe1ec2b8ebd5622520b73;
          tv[246]= 384'h00000000000000000000000000000000ffffffffffffffffffffffe0000000007472f9a7988607ca79707795991035e6;
          tv[247]= 384'h00000000000000000000000000000000fffffffffffffffffffffff00000000056aff089878bf3352f8df172a3ae47d8;
          tv[248]= 384'h00000000000000000000000000000000fffffffffffffffffffffff80000000065c0526cbe40161b8019a2a3171abd23;
          tv[249]= 384'h00000000000000000000000000000000fffffffffffffffffffffffc00000000377be0be33b4e3e310b4aabda173f84f;
          tv[250]= 384'h00000000000000000000000000000000fffffffffffffffffffffffe000000009402e9aa6f69de6504da8d20c4fcaa2f;
          tv[251]= 384'h00000000000000000000000000000000ffffffffffffffffffffffff00000000123c1f4af313ad8c2ce648b2e71fb6e1;
          tv[252]= 384'h00000000000000000000000000000000ffffffffffffffffffffffff800000001ffc626d30203dcdb0019fb80f726cf4;
          tv[253]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffc000000076da1fbe3a50728c50fd2e621b5ad885;
          tv[254]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffe0000000082eb8be35f442fb52668e16a591d1d6;
          tv[255]= 384'h00000000000000000000000000000000fffffffffffffffffffffffff0000000e656f9ecf5fe27ec3e4a73d00c282fb3;
          tv[256]= 384'h00000000000000000000000000000000fffffffffffffffffffffffff80000002ca8209d63274cd9a29bb74bcd77683a;
          tv[257]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffc00000079bf5dce14bb7dd73a8e3611de7ce026;
          tv[258]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffe0000003c849939a5d29399f344c4a0eca8a576;
          tv[259]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffff000000ed3c0a94d59bece98835da7aa4f07ca2;
          tv[260]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffff80000063919ed4ce10196438b6ad09d99cd795;
          tv[261]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffc000007678f3a833f19fea95f3c6029e2bc610;
          tv[262]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffe000003aa426831067d36b92be7c5f81c13c56;
          tv[263]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffff000009272e2d2cdd11050998c845077a30ea0;
          tv[264]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffff80000088c4b53f5ec0ff814c19adae7f6246c;
          tv[265]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffc00004010a5e401fdf0a0354ddbcc0d012b17;
          tv[266]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffe0000a87a385736c0a6189bd6589bd8445a93;
          tv[267]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffff0000545f2b83d9616dccf60fa9830e9cd287;
          tv[268]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffff80004b706f7f92406352394037a6d4f4688d;
          tv[269]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffc000b7972b3941c44b90afa7b264bfba7387;
          tv[270]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffe0006f45732cf10881546f0fd23896d2bb60;
          tv[271]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffff0002e3579ca15af27f64b3c955a5bfc30ba;
          tv[272]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffff80034a2c5a91ae2aec99b7d1b5fa6780447;
          tv[273]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffc00a4d6616bd04f87335b0e53351227a9ee;
          tv[274]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffe007f692b03945867d16179a8cefc83ea3f;
          tv[275]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffff003bd141ee84a0e6414a26e7a4f281f8a2;
          tv[276]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffff80d1788f572d98b2b16ec5d5f3922b99bc;
          tv[277]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffffc00833ff6f61d98a57b288e8c3586b85a6;
          tv[278]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffffe08568261797de176bf0b43becc6285afb;
          tv[279]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffff0f9b0fda0c4a898f5b9e6f661c4ce4d07;
          tv[280]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffff88ade895913685c67c5269f8aae42983e;
          tv[281]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffffc39bde67d5c8ed8a8b1c37eb8fa9f5ac0;
          tv[282]= 384'h00000000000000000000000000000000fffffffffffffffffffffffffffffffe5c005e72c1418c44f569f2ea33ba54f3;
          tv[283]= 384'h00000000000000000000000000000000ffffffffffffffffffffffffffffffff3f5b8cc9ea855a0afa7347d23e8d664e;
          
          
          for(n=0;n<284;n=n+1)
            begin
	      @(posedge clk);
	      #1;
	      kld = 1;
	      @(posedge clk);
	      #1;
	      kld = 0;
	      @(posedge clk);

	      while(!done)	@(posedge clk);

	      //$display("INFO: (a) Vector %0d: xpected %x, Got %x %t", n, ciph, text_out, $time);

	      if(text_out != ciph | (|text_out)==1'bx)
	        begin
		  $display("ERROR: (a) Vector %0d mismatch. Expected %x, Got %x",
			   n, ciph, text_out);
		  error_cnt = error_cnt + 1;
	        end


/* -----\/----- EXCLUDED -----\/-----
	      while(!done2)	@(posedge clk);

	      //$display("INFO: (b) Vector %0d: xpected %x, Got %x", n, plain, text_out2);

	      if(text_out2 != plain | (|text_out2)==1'bx)
	        begin
		  $display("ERROR: (b) Vector %0d mismatch. Expected %x, Got %x",
			   n, plain, text_out2);
		  error_cnt = error_cnt + 1;
	        end
 -----/\----- EXCLUDED -----/\----- */
              

	      @(posedge clk);
	      #1;
            end // for (n=0;n<284;n=n+1)
          


	  $display("");
	  $display("");
	  $display("Test Done. Found %0d Errors.", error_cnt);
	  $display("");
	  $display("");
	  repeat(10)	@(posedge clk);
        end // while (1)
      
      //	$finish;
    end // initial begin
  

  assign tmp = tv[n];
  assign key     = tmp[383:256]; //kld ? tmp[383:256] : 128'hx;
  assign text_in = tmp[255:128]; //kld ? tmp[255:128] : 128'hx;
  assign plain   = tmp[255:128];
  assign ciph    = tmp[127:0];

  always #5 clk = ~clk;

  aes_cipher_top	 u0
    (
     .clk(		clk		),
     .rst(		rst		),
     .ld(		kld		),
     .done(		done		),
     .key(		key		),
     .text_in(	text_in		),
     .text_out(	text_out	)
     );

/*
  initial 
    begin
      #107000000
        $finish;
    end
*/
  
/* -----\/----- EXCLUDED -----\/-----
  initial
    begin
      $vcdpluson;
    end
 -----/\----- EXCLUDED -----/\----- */
  
  
endmodule
// Local Variables:
// verilog-library-directories:("." "./gl")
// End:
