module crc(
    input [23:0] init_i,
    input update_init_i,
    input data_i,
    input en_i,
    input clk,
    input rst_n,
    output reg [23:0] crc_o
);
wire msb_xor;
assign msb_xor = crc_o[23]^data_i;
always @(posedge clk,negedge rst_n) begin
    if(!rst_n)
        crc_o <= 24'b0;
    else begin
        if(update_init_i)
            crc_o <= init_i;
        else if(en_i)
            crc_o <= {
                crc_o[22],
                crc_o[21],
                crc_o[20],
                crc_o[19],
                crc_o[18],
                crc_o[17],
                crc_o[16],
                crc_o[15],
                crc_o[14],
                crc_o[13],
                crc_o[12],
                crc_o[11],
                crc_o[10],
                msb_xor^crc_o[9],
                msb_xor^crc_o[8],
                crc_o[7],
                crc_o[6],
                msb_xor^crc_o[5],
                crc_o[4],
                msb_xor^crc_o[3],
                msb_xor^crc_o[2],
                crc_o[1],
                msb_xor^crc_o[0],
                msb_xor
            };
    end
    
end
endmodule