`include "defines.v"
module mac_top(
    input [9:2] haddr_i,
    input hwrite_i,
    input [31:0] hwdata_i,
    output [31:0] hrdata_o,
    input [2:0] hsize_i,
    input [1:0] htrans_i,
    input [2:0] hburst_i,
    input hready_i,
    output hready_o,
    output hresp_o,
    input hsel_i,
    output tx_en_o,
    output tx_data_o,
    output tx_data_valid_o,
    output [5:0] channel_o,
    output rx_en_o,
    output [31:0] rx_sync_word_o,
    input rx_data_i,
    input rx_data_valid_i,
    input sync_found_i,
    output irq1_o,
    output irq2_o,
    input clk,
    input rst_n
);

wire [7:0] tx_up_us;
wire [7:0] tx_down_us;
wire [31:0] sync_word;
wire [1:0] rate;
wire [7:0] tx_payload_length;
wire [23:0] crc_init;
wire [6:0] whiten_init;
wire whiten_bypass;
wire tx_fsm_en;
wire tx_fsm_stop;
wire [31:0] start_time;
wire [31:0] target_time1;
wire [8:0] rx_up_us;
wire rx_fsm_en;
wire rx_fsm_stop;
wire [16:0] int_mask1;
wire fifo_dir;
wire fifo_clr;
wire [7:0] fifo_tx_threshold;
wire [7:0] fifo_rx_threshold;
wire [127:0] aes_data;
wire aes_en;
wire aes_start;
wire [7:0] aes_head_mask;
wire [127:0] aes_key;
wire [31:0] target_time2;
wire [16:0] int_mask2;
wire fifo_tx_push;
wire [7:0] fifo_tx_wr_data;
wire fifo_rx_pop;
wire [16:0] int_clr_req;
wire [16:0] int_raw;
wire [16:0] int_stat1;
wire [16:0] int_stat2;
wire [7:0] fifo_rx_rd_data;
wire [6:0] fifo_lvl;
wire [31:0] current_time;
wire [31:0] rx_time;
wire [23:0] crc_rslt;
wire mic_error;
wire [127:0] aes_rslt;
regs regs_inst(
    .haddr_i(haddr_i),
    .hwrite_i(hwrite_i),
    .hwdata_i(hwdata_i),
    .hrdata_o(hrdata_o),
    .hsize_i(hsize_i),
    .htrans_i(htrans_i),
    .hburst_i(hburst_i),
    .hready_i(hready_i),
    .hready_o(hready_o),
    .hresp_o(hresp_o),
    .hsel_i(hsel_i),
    .tx_up_o(tx_up_us),
    .tx_down_o(tx_down_us),
    .sync_word_o(sync_word),
    .rate_o(rate),
    .channel_o(channel_o),
    .tx_payload_length_o(tx_payload_length),
    .crc_init_o(crc_init),
    .whiten_init_o(whiten_init),
    .whiten_bypass_o(whiten_bypass),
    .tx_fsm_en_o(tx_fsm_en),
    .tx_fsm_stop_o(tx_fsm_stop),
    .start_time_o(start_time),
    .target_time1_o(target_time1),
    .rx_up_o(rx_up_us),
    .rx_fsm_en_o(rx_fsm_en),
    .rx_fsm_stop_o(rx_fsm_stop),
    .int_mask1_o(int_mask1),
    .fifo_dir_o(fifo_dir),
    .fifo_clr_o(fifo_clr),
    .fifo_tx_threshold_o(fifo_tx_threshold),
    .fifo_rx_threshold_o(fifo_rx_threshold),
    .aes_data_o(aes_data),
    .aes_en_o(aes_en),
    .aes_start_o(aes_start),
    .aes_head_mask_o(aes_head_mask),
    .aes_key_o(aes_key),
    .target_time2_o(target_time2),
    .int_mask2_o(int_mask2),
    .fifo_tx_push_o(fifo_tx_push),
    .fifo_tx_wr_data_o(fifo_tx_wr_data),
    .fifo_rx_pop_o(fifo_rx_pop),
    .int_clr_req_o(int_clr_req),
    .int_raw_i(int_raw),
    .int_stat1_i(int_stat1),
    .int_stat2_i(int_stat2),
    .fifo_rx_rd_data_i(fifo_rx_rd_data),
    .fifo_lvl_i(fifo_lvl),
    .current_time_i(current_time),
    .rx_time_i(rx_time),
    .crc_rslt_i(crc_rslt),
    .mic_error_i(mic_error),
    .aes_rslt_i(aes_rslt),
    .clk(clk),
    .rst_n(rst_n)
);

mac mac_inst(
    .tx_up_us_i(tx_up_us),
    .tx_down_us_i(tx_down_us),
    .sync_word_i(sync_word),
    .rate_i(rate),
    .tx_payload_length_i(tx_payload_length),
    .crc_init_i(crc_init),
    .whiten_init_i(whiten_init),
    .whiten_bypass_i(whiten_bypass),
    .tx_fsm_en_i(tx_fsm_en),
    .tx_fsm_stop_i(tx_fsm_stop),
    .start_time_i(start_time),
    .target_time1_i(target_time1),
    .rx_up_us_i(rx_up_us),
    .rx_fsm_en_i(rx_fsm_en),
    .rx_fsm_stop_i(rx_fsm_stop),
    .int_mask1_i(int_mask1),
    .fifo_dir_i(fifo_dir),
    .fifo_clr_i(fifo_clr),
    .fifo_tx_threshold_i(fifo_tx_threshold),
    .fifo_rx_threshold_i(fifo_rx_threshold),
    .aes_data_i(aes_data),
    .aes_en_i(aes_en),
    .aes_start_i(aes_start),
    .aes_head_mask_i(aes_head_mask),
    .aes_key_i(aes_key),
    .target_time2_i(target_time2),
    .int_mask2_i(int_mask2),
    .fifo_tx_push_i(fifo_tx_push),
    .fifo_tx_wr_data_i(fifo_tx_wr_data),
    .fifo_rx_pop_i(fifo_rx_pop),
    .int_clr_req_i(int_clr_req),
    .int_raw_o(int_raw),
    .int_stat1_o(int_stat1),
    .int_stat2_o(int_stat2),
    .fifo_rx_rd_data_o(fifo_rx_rd_data),
    .fifo_lvl_o(fifo_lvl),
    .current_time_o(current_time),
    .rx_time_o(rx_time),
    .crc_rslt_o(crc_rslt),
    .mic_error_o(mic_error),
    .aes_rslt_o(aes_rslt),
    .tx_en_o(tx_en_o),
    .tx_data_o(tx_data_o),
    .tx_data_valid_o(tx_data_valid_o),
    .rx_en_o(rx_en_o),
    .rx_sync_word_o(rx_sync_word_o),
    .rx_data_i(rx_data_i),
    .rx_data_valid_i(rx_data_valid_i),
    .sync_found_i(sync_found_i),
    .irq1_o(irq1_o),
    .irq2_o(irq2_o),
    .clk(clk),
    .rst_n(rst_n)
);

endmodule