module regs(
    input [9:2] haddr_i,
    input hwrite_i,
    input [31:0] hwdata_i,
    output reg [31:0] hrdata_o,
    input [2:0] hsize_i,
    input [1:0] htrans_i,
    input [2:0] hburst_i,
    input hready_i,
    output hready_o,
    output hresp_o,
    input hsel_i,
    output reg [7:0] tx_up_o,
    output reg [7:0] tx_down_o,
    output reg [31:0] sync_word_o,
    output reg [1:0] rate_o,
    output reg [5:0] channel_o,
    output reg [7:0] tx_payload_length_o,
    output reg [23:0] crc_init_o,
    output reg [6:0] whiten_init_o,
    output reg whiten_bypass_o,
    output reg tx_fsm_en_o,
    output reg tx_fsm_stop_o,
    output reg [31:0] start_time_o,
    output reg [31:0] target_time1_o,
    output reg [8:0] rx_up_o,
    output reg rx_fsm_en_o,
    output reg rx_fsm_stop_o,
    output reg [16:0] int_mask1_o,
    output reg fifo_dir_o,
    output reg fifo_clr_o,
    output reg [7:0] fifo_tx_threshold_o,
    output reg [7:0] fifo_rx_threshold_o,
    output reg [127:0] aes_data_o,
    output reg aes_en_o,
    output reg aes_start_o,
    output reg [7:0] aes_head_mask_o,
    output reg [127:0] aes_key_o,
    output reg [31:0] target_time2_o,
    output reg [16:0] int_mask2_o,
    output fifo_tx_push_o,
    output [7:0] fifo_tx_wr_data_o,
    output fifo_rx_pop_o,
    output [16:0] int_clr_req_o,
    input [16:0] int_raw_i,
    input [16:0] int_stat1_i,
    input [16:0] int_stat2_i,
    input [7:0] fifo_rx_rd_data_i,
    input [6:0] fifo_lvl_i,
    input [31:0] current_time_i,
    input [31:0] rx_time_i,
    input [23:0] crc_rslt_i,
    input mic_error_i,
    input [127:0] aes_rslt_i,
    input clk,
    input rst_n
    );
assign hready_o = 1;
assign hresp_o = 0;
reg [9:2] haddr_r;
reg hwrite_r;
reg hdata_valid;
assign fifo_tx_push_o = hdata_valid && haddr_r == 24 && hwrite_r == 1;
assign fifo_tx_wr_data_o = hwdata_i[7:0];
assign fifo_rx_pop_o = hdata_valid && haddr_r == 25 && hwrite_r == 0;
assign int_clr_req_o = hwdata_i[16:0] & {17{hdata_valid && haddr_r == 17 && hwrite_r == 1}};
always @(posedge clk,negedge rst_n) begin
    if(!rst_n) begin
        haddr_r <= 0;
        hwrite_r <= 0;
        hdata_valid <= 0;
    end
    else if(hsel_i && hready_i) begin
        haddr_r <= haddr_i;
        hwrite_r <= hwrite_i;
        hdata_valid <= 1;
    end
    else begin
        hdata_valid <= 0;
    end
end
always @(posedge clk,negedge rst_n) begin
    if(!rst_n) begin
        tx_up_o <= 0;
        tx_down_o <= 0;
        sync_word_o <= 0;
        rate_o <= 0;
        channel_o <= 0;
        tx_payload_length_o <= 0;
        crc_init_o <= 0;
        whiten_init_o <= 0;
        whiten_bypass_o <= 0;
        tx_fsm_en_o <= 0;
        tx_fsm_stop_o <= 0;
        start_time_o <= 0;
        target_time1_o <= 0;
        rx_up_o <= 0;
        rx_fsm_en_o <= 0;
        rx_fsm_stop_o <= 0;
        int_mask1_o <= 0;
        fifo_dir_o <= 0;
        fifo_clr_o <= 0;
        fifo_tx_threshold_o <= 0;
        fifo_rx_threshold_o <= 0;
        aes_data_o <= 0;
        aes_en_o <= 0;
        aes_start_o <= 0;
        aes_head_mask_o <= 0;
        aes_key_o <= 0;
        target_time2_o <= 0;
        int_mask2_o <= 0;
    end
    else if(hwrite_r) begin
        case(haddr_r)
            2: begin
                tx_up_o <= hwdata_i[7:0];
                tx_down_o <= hwdata_i[15:8];
            end
            3: sync_word_o <= hwdata_i;
            4: begin
                rate_o <= hwdata_i[3:2];
                channel_o <= hwdata_i[17:12];
            end
            5: tx_payload_length_o <= hwdata_i[7:0];
            7: begin
                crc_init_o <= hwdata_i[23:0];
                whiten_init_o <= hwdata_i[30:24];
                whiten_bypass_o <= hwdata_i[31];
            end
            8: begin
                tx_fsm_en_o <= hwdata_i[0];
                tx_fsm_stop_o <= hwdata_i[4];
            end
            9: start_time_o <= hwdata_i;
            10: target_time1_o <= hwdata_i;
            12: rx_up_o <= hwdata_i[8:0];
            15: begin
                rx_fsm_en_o <= hwdata_i[0];
                rx_fsm_stop_o <= hwdata_i[4];
            end
            16: int_mask1_o <= hwdata_i[16:0];
            20: begin 
                fifo_dir_o <= hwdata_i[0];
                fifo_clr_o <= hwdata_i[4];
            end
            21: fifo_tx_threshold_o <= hwdata_i[7:0];
            22: fifo_rx_threshold_o <= hwdata_i[7:0];
            40: aes_data_o[31:0] <= hwdata_i;
            41: aes_data_o[63:32] <= hwdata_i;
            42: aes_data_o[95:64] <= hwdata_i;
            43: aes_data_o[127:96] <= hwdata_i;
            44: begin
                aes_en_o <= hwdata_i[0];
                aes_start_o <= hwdata_i[4];
                aes_head_mask_o <= hwdata_i[23:16];
            end
            45: aes_key_o[31:0] <= hwdata_i;
            46: aes_key_o[63:32] <= hwdata_i;
            47: aes_key_o[95:64] <= hwdata_i;
            48: aes_key_o[127:96] <= hwdata_i;
            56: target_time2_o <= hwdata_i;
            57: int_mask2_o <= hwdata_i[16:0];
        endcase 
    end
end

always @(*) begin
    hrdata_o = 0;
    if(hwrite_r == 0) begin
        case (haddr_r)
            7: hrdata_o = whiten_bypass_o<<31|whiten_init_o<<24|crc_init_o;
            10: hrdata_o = target_time1_o;
            16: hrdata_o = int_mask1_o;
            18: hrdata_o = int_stat1_i;
            19: hrdata_o = int_raw_i;
            25: hrdata_o = fifo_rx_rd_data_i;
            28: hrdata_o = fifo_lvl_i<<16;
            29: hrdata_o = current_time_i;
            30: hrdata_o = rx_time_i;
            33: hrdata_o = mic_error_i<<24 | crc_rslt_i;
            56: hrdata_o = target_time2_o;
            57: hrdata_o = int_mask2_o;
            58: hrdata_o = int_stat2_i;
            60: hrdata_o = aes_rslt_i[31:0];
            61: hrdata_o = aes_rslt_i[63:32];
            62: hrdata_o = aes_rslt_i[95:64];
            63: hrdata_o = aes_rslt_i[127:96];
        endcase
    end
end
endmodule
