module whiten (
    input [6:0] init_i,
    input update_init_i,
    input data_i,
    input shift_i,
    input clk,
    input rst_n,
    output data_o
);
reg [6:0] coef;
assign data_o = data_i ^ coef[6];
always @( posedge clk,negedge rst_n ) begin
    if(!rst_n)
        coef <= 7'b0;
    else begin
        if(update_init_i)
            coef <= init_i;
        else if(shift_i) 
            coef <= {coef[5],coef[4],coef[6]^coef[3],coef[2],coef[1],coef[0],coef[6]};
    end
end
endmodule